---
title: Build durable multi-step applications in Python with Workflows (now in
  beta) · Changelog
description: Python Workflows is now open beta - build Workflows in Python.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-22-workflows-python-beta/
  md: https://developers.cloudflare.com/changelog/2025-08-22-workflows-python-beta/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Build durable multi-step applications in Python with Workflows (now in beta)

Aug 22, 2025

[Workflows ](https://developers.cloudflare.com/workflows/)[Workers](https://developers.cloudflare.com/workers/)

You can now build [Workflows](https://developers.cloudflare.com/workflows/) using Python. With Python Workflows, you get automatic retries, state persistence, and the ability to run multi-step operations that can span minutes, hours, or weeks using Python’s familiar syntax and the [Python Workers](https://developers.cloudflare.com/workers/languages/python/) runtime.

Python Workflows use the same step-based execution model as JavaScript Workflows, but with Python syntax and access to Python’s ecosystem. Python Workflows also enable [DAG (Directed Acyclic Graph) workflows](https://developers.cloudflare.com/workflows/python/dag/), where you can define complex dependencies between steps using the depends parameter.

Here’s a simple example:

```python
from workers import Response, WorkflowEntrypoint


class PythonWorkflowStarter(WorkflowEntrypoint):
    async def run(self, event, step):
        @step.do("my first step")
        async def my_first_step():
            # do some work
            return "Hello Python!"


        await my_first_step()


        await step.sleep("my-sleep-step", "10 seconds")


        @step.do("my second step")
        async def my_second_step():
            # do some more work
            return "Hello again!"


        await my_second_step()


class Default(WorkerEntrypoint):
    async def fetch(self, request):
        await self.env.MY_WORKFLOW.create()
        return Response("Hello Workflow creation!")
```

Note

Python Workflows requires a `compatibility_date = "2025-08-01"`, or lower, in your wrangler toml file.

Python Workflows support the same core capabilities as JavaScript Workflows, including sleep scheduling, event-driven workflows, and built-in error handling with configurable retry policies.

To learn more and get started, refer to [Python Workflows documentation](https://developers.cloudflare.com/workflows/python/).
