---
title: WAF Release - 2025-09-15 · Changelog
description: Cloudflare WAF managed rulesets 2025-09-15 release
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-15-waf-release/
  md: https://developers.cloudflare.com/changelog/2025-09-15-waf-release/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## WAF Release - 2025-09-15

Sep 15, 2025

[WAF](https://developers.cloudflare.com/waf/)

**This week's update**

This week's focus highlights newly disclosed vulnerabilities in DevOps tooling, data visualization platforms, and enterprise CMS solutions. These issues include sensitive information disclosure and remote code execution, putting organizations at risk of credential leakage, unauthorized access, and full system compromise.

**Key Findings**

* Argo CD (CVE-2025-55190): Exposure of sensitive information could allow attackers to access credential data stored in configurations, potentially leading to compromise of Kubernetes workloads and secrets.

* DataEase (CVE-2025-57773): Insufficient input validation enables JNDI injection and insecure deserialization, resulting in remote code execution (RCE). Successful exploitation grants attackers control over the application server.

* Sitecore (CVE-2025-53694): A sensitive information disclosure flaw allows unauthorized access to confidential information stored in Sitecore deployments, raising the risk of data breaches and privilege escalation.

**Impact**

These vulnerabilities expose organizations to serious risks, including credential theft, unauthorized access, and full system compromise. Argo CD's flaw may expose Kubernetes secrets, DataEase exploitation could give attackers remote execution capabilities, and Sitecore's disclosure issue increases the likelihood of sensitive data leakage and business impact.

Administrators are strongly advised to apply vendor patches immediately, rotate exposed credentials, and review access controls to mitigate these risks.

| Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
| - | - | - | - | - | - | - |
| Cloudflare Managed Ruleset | 199cce9ab21e40bcb535f01b2ee2085f | 100646 | Argo CD - Information Disclosure - CVE:CVE-2025-55190s | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | e513bb21b6a44f9cbfcd2462f5e20788 | 100874 | DataEase - JNDI injection - CVE:CVE-2025-57773 | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | be097f5a71a04f27aa87b60d005a12fd | 100880 | Sitecore - Information Disclosure - CVE:CVE-2025-53694 | Log | Block | This is a New Detection |
