---
title: Cloud Services Observability in Cloudflare Radar · Changelog
description: New HTTP Origins insights in Cloudflare Radar, including service
  status, traffic, and connectivity metrics
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-11-24-radar-cloud-observability/
  md: https://developers.cloudflare.com/changelog/2025-11-24-radar-cloud-observability/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Cloud Services Observability in Cloudflare Radar

Nov 24, 2025

[Radar](https://developers.cloudflare.com/radar/)

[**Radar**](https://developers.cloudflare.com/radar/) introduces HTTP Origins insights, providing visibility into the status of traffic between Cloudflare's global network and cloud-based origin infrastructure.

The new [`Origins`](https://developers.cloudflare.com/api/resources/radar/subresources/origins/) API provides provides the following endpoints:

* [`/origins`](https://developers.cloudflare.com/api/resources/radar/subresources/origins/methods/list/) - Lists all origins (cloud providers and associated regions).

* [`/origins/{origin}`](https://developers.cloudflare.com/api/resources/radar/subresources/origins/methods/get/) - Retrieves information about a specific origin (cloud provider).

* [`/origins/timeseries`](https://developers.cloudflare.com/api/resources/radar/subresources/origins/methods/timeseries/) - Retrieves normalized time series data for a specific origin, including the following metrics:

  * `REQUESTS`: Number of requests
  * `CONNECTION_FAILURES`: Number of connection failures
  * `RESPONSE_HEADER_RECEIVE_DURATION`: Duration of the response header receive
  * `TCP_HANDSHAKE_DURATION`: Duration of the TCP handshake
  * `TCP_RTT`: TCP round trip time
  * `TLS_HANDSHAKE_DURATION`: Duration of the TLS handshake

* [`/origins/summary`](https://developers.cloudflare.com/api/resources/radar/subresources/origins/methods/summary/) - Retrieves HTTP requests to origins summarized by a dimension.

* [`/origins/timeseries_groups`](https://developers.cloudflare.com/api/resources/radar/subresources/origins/methods/timeseries_groups/) - Retrieves timeseries data for HTTP requests to origins grouped by a dimension.

The following dimensions are available for the `summary` and `timeseries_groups` endpoints:

* `region`: Origin region
* `success_rate`: Success rate of requests (2XX versus 5XX response codes)
* `percentile`: Percentiles of metrics listed above

Additionally, the [`Annotations`](https://developers.cloudflare.com/api/resources/radar/subresources/annotations/) and [`Traffic Anomalies`](https://developers.cloudflare.com/api/resources/radar/subresources/traffic_anomalies/) APIs have been extended to support origin outages and anomalies, enabling automated detection and alerting for origin infrastructure issues.

![Screenshot of the cloud service status heatmap](https://developers.cloudflare.com/_astro/cloud-service-status.DoGHSNmz_ZYLgwJ.webp)

Check out the [new Radar page](https://radar.cloudflare.com/cloud-observatory).
