---
title: Control incoming requests · Cloudflare Learning Paths
description: Use Custom rules to allow you to control incoming traffic by
  filtering requests to a zone. They work as customized web application firewall
  (WAF) rules that you can use to perform actions like Block or Managed
  Challenge on incoming requests.
lastUpdated: 2025-09-25T16:31:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/surge-readiness/security/control-incoming-requests/
  md: https://developers.cloudflare.com/learning-paths/surge-readiness/security/control-incoming-requests/index.md
---

Use [Custom rules](https://developers.cloudflare.com/waf/custom-rules/) to allow you to control incoming traffic by filtering requests to a zone. They work as customized web application firewall (WAF) rules that you can use to perform actions like Block or Managed Challenge on incoming requests.

Use WAF [Managed Rules](https://developers.cloudflare.com/waf/managed-rules/) to apply custom criteria for all incoming HTTP requests.

## Understand hosting plan limits

Cloudflare offsets most of the load to your website via caching and request filtering, but some traffic will still pass through to your origin. Knowing the limits of your hosting plan can help prevent a bottleneck from your host.

Once you are aware of your plan limits, you can use [Rate Limiting](https://developers.cloudflare.com/waf/rate-limiting-rules/) to restrict how many times a requesting entity can make a request to your website.

To help you define the best rate limiting setting for your use case, refer to [How Cloudflare determines the request rate](https://developers.cloudflare.com/waf/rate-limiting-rules/request-rate/).

## Security models

* Positive Security policy: Allow specific requests and deny everything else.
* Negative Security policy: Block specific requests and allow everything else.

## Actions

* Log: Test rule effectiveness before committing to a more severe action.
* Allow: Allow matching requests to access the site.
* Block: Block matching requests from accessing the site.
* CAPTCHA Challenge: Rules will be shown a CAPTCHA before proceeding.
* Javascript Challenge: Rules will be shown a five second Javascript confirmation before proceeding.
