---
title: Permissions · Cloudflare Logs docs
description: Below is a description of the available permissions for tokens and
  roles as they relate to Logs. For information about how to create an API
  token, refer to Creating API tokens.
lastUpdated: 2025-11-05T11:56:20.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/logpush/permissions/
  md: https://developers.cloudflare.com/logs/logpush/permissions/index.md
---

Below is a description of the available permissions for tokens and roles as they relate to Logs. For information about how to create an API token, refer to [Creating API tokens](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/).

## Tokens

* **Logs: Read** - Grants read access to logs using Logpull or Instant Logs.

* **Logs: Write** - Grants read and write access to Logpull and Logpush, and read access to Instant Logs. Note that all Logpush API operations require **Logs: Write** permission because Logpush jobs contain sensitive information.

Note

* **Zone-scoped datasets** require a **zone-scoped token**.
* **Account-scoped datasets** require an **account-scoped token**.

Permissions must be explicitly configured at the appropriate level (zone or account) to ensure access to the desired API endpoints.

## Roles

**Super Administrator**, **Administrator** and the **Log Share** roles have full access to Logpull, Logpush and Instant Logs.

Only roles with **Log Share** edit permissions can read and configure Logpush jobs because job configurations may contain sensitive information.

The **Administrator Read only** and **Log Share Reader** roles only have access to Instant Logs and Logpull. This role does not have permissions to view the configuration of Logpush jobs.

### Zero Trust datasets

To view, create, update, or delete Logpush jobs for Zero Trust datasets (Access, Gateway, and DEX) users must have both the `Logs Edit` and `Zero Trust: PII Read` permissions.

### Assign or remove a role

To check the list of members in your account, or to manage roles and permissions:

1. Navigate to the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account.
2. From your Account Home, go to **Manage Account** > **Members**.
3. Enter a member’s email address to add them to your account, and select **Invite**.
4. Alternatively, scroll down to the **Members** card to find a list of members with their status and role.

For more information, refer to [Managing roles within your Cloudflare account](https://developers.cloudflare.com/fundamentals/manage-members/).
