---
title: Configure rule notifications · Cloudflare Magic Network Monitoring docs
description: After configuring one or multiple rule types in Magic Network
  Monitoring, customers can also choose to receive notifications via email,
  webhook, or PagerDuty when a rule is triggered.
lastUpdated: 2025-11-19T16:38:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/rules/rule-notifications/
  md: https://developers.cloudflare.com/magic-network-monitoring/rules/rule-notifications/index.md
---

After configuring one or multiple rule types in Magic Network Monitoring, customers can also choose to receive notifications via email, webhook, or PagerDuty when a rule is triggered.

Customers can configure multiple rule types and alerts together to create layers of DDoS protection based on their network environment and their security needs.

You can read [Cloudflare's Notifications documentation](https://developers.cloudflare.com/notifications/) for more information on our notification platform including:

* [Configure Cloudflare notifications](https://developers.cloudflare.com/notifications/get-started/)
* [Configure PagerDuty](https://developers.cloudflare.com/notifications/get-started/configure-pagerduty/)
* [Configure webhooks](https://developers.cloudflare.com/notifications/get-started/configure-webhooks/)
* [Test a notification](https://developers.cloudflare.com/notifications/get-started/#test-a-notification)
* [Notification History](https://developers.cloudflare.com/notifications/notification-history/)

## notification configuration fields

| Field | Description |
| - | - |
| **Notification name** | The name of the notification () for the rule type that was selected. |
| **Description (optional)** | The description of the notification. |
| **Webhooks** | The webhook(s) that will receive the notification. |
| **Notification email** | The email(s) that will receive the notification. |

## Rule Auto-Advertisement notifications

Webhook, PagerDuty, and email notifications are sent following an auto-advertisement attempt for all prefixes inside the flagged rule.

You will receive the status of the advertisement for each prefix with the following available statuses:

* **Advertised**: The prefix was successfully advertised.
* **Already Advertised**: The prefix was advertised prior to the auto advertisement attempt.
* **Delayed**: The prefix cannot currently be advertised but will attempt advertisement. After the prefix can be advertised, a new notification is sent with the updated status.
* **Locked**: The prefix is locked and cannot be advertised.
* **Could not Advertise**: Cloudflare was unable to advertise the prefix. This status can occur for multiple reasons, but usually occurs when you are not allowed to advertise a prefix.
* **Error**: A general error occurred during prefix advertisement.

## Configure static threshold notifications

To configure static threshold notifications:

1. In the Cloudflare dash, go to the **Notifications** page.

[Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

1. Select **Add**.
2. Select **Magic Transit** from the product dropdown menu.
3. Find the **Magic Network Monitoring: Volumetric Attack** alert, and select **Select**.
4. Fill in the notification configuration details.
5. Select **Save**.

## Configure dynamic threshold notifications

To configure dynamic threshold notifications:

1. In the Cloudflare dash, go to the **Notifications** page.

[Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

1. Select **Add**.
2. Select **Magic Transit** from the product dropdown menu.
3. Find the **Magic Network Monitoring: Volumetric Attack** alert, and select **Select**.
4. Fill in the notification configuration details.
5. Select **Save**.

## Configure sFlow DDoS attack notifications

To configure sFlow DDoS attack notifications:

1. In the Cloudflare dash, go to the **Notifications** page.

[Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

1. Select **Add**.
2. Select **Magic Transit** from the product dropdown menu.
3. Find the **Magic Network Monitoring: DDoS Attack** alert, and select **Select**.
4. Fill in the notification configuration details.
5. Select **Save**.
