---
title: http.request.body.raw · Cloudflare Ruleset Engine docs
description: The unaltered HTTP request body.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.raw/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.raw/index.md
---

# http.request.body.raw

`http.request.body.raw` String

The unaltered HTTP request body.

When the value of [`http.request.body.truncated`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.truncated/) is `true`, the return value may be truncated.

* **Decoding**: No decoding performed
* **Whitespace**: Preserved
* **Non-ASCII**: Preserved

Requires a Cloudflare Enterprise plan with a paid add-on.

Warning

All `http.request.body.*` fields (except [`http.request.body.size` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.size/)) handle a given maximum body size, which varies per plan. For Enterprise customers, the maximum body size analyzed by Cloudflare is 128 KB; for lower Cloudflare plans, the maximum size is lower. You cannot define expressions that rely on request body data beyond the maximum size set for your plan. If the request body is larger, the body fields will contain a truncated value and the [`http.request.body.truncated` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.truncated/)field will be set to `true`. The [`http.request.body.size` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.size/)field will contain the full size of the request without any truncation.

The maximum body size applies only to the values of HTTP body fields — the origin server will still receive the complete request body.

Categories:

* Request
* Body
* Raw fields
