---
title: Dedicated CDN Egress IPs · Cloudflare Smart Shield docs
description: Enterprise customers can leverage dedicated egress1 IPs for layer 7
  WAF and CDN services, as well as Spectrum. The egress IPs are reserved
  exclusively for your account so that you can increase your origin security by
  only allowing traffic from a small list of IP addresses.
lastUpdated: 2025-11-19T12:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/
  md: https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/index.md
---

Enterprise customers can leverage dedicated egress[1](#user-content-fn-1) IPs for layer 7 [WAF](https://developers.cloudflare.com/waf/) and CDN services, as well as [Spectrum](https://developers.cloudflare.com/spectrum/). The egress IPs are reserved exclusively for your account so that you can increase your origin security by only allowing traffic from a small list of IP addresses.

Note

If you are interested in using Smart Shield Advanced with Dedicated CDN Egress IPs, reach out to your account team.

Dedicated CDN Egress IPs was formerly known as Cloudflare Aegis ([release blog post](https://blog.cloudflare.com/cloudflare-aegis/)).

## Benefits

With Dedicated CDN Egress IPs, you can:

* Lock down your network firewall to only allow traffic from your dedicated IPs.
* Use [Cloudflare Access and CNI](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/other-products/#access-and-cni) to secure your applications without installing software or customizing code on your server.
* Ensure only authorized [Workers](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/other-products/#workers) can access your origin services.

## Scope

You can assign Dedicated CDN Egress IPs to single or multiple Cloudflare zones, and across different Cloudflare accounts.

Dedicated CDN Egress IPs are included within [BGP advertisement over CNI](https://developers.cloudflare.com/network-interconnect/).

Each dedicated egress pool can consist of either IPs from a [BYOIP prefix](https://developers.cloudflare.com/byoip/) or Cloudflare-leased IPs. A single dedicated egress pool cannot contain both BYOIPs and leased IPs.

## Resources

* [How it works](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/how-it-works/)
* [IPs utilization](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/ips-utilization/)
* [Use with other Cloudflare products](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/other-products/)

## Footnotes

1. From Cloudflare to your origin. Refer to [how it works](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/how-it-works/egress-ips/) for details. [↩](#user-content-fnref-1)
