---
title: External resources · Cloudflare Style Guide
description: The ExternalResources component pulls from a central list of apps and videos.
lastUpdated: 2025-03-06T21:11:46.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/external-resources/
  md: https://developers.cloudflare.com/style-guide/components/external-resources/index.md
---

The `ExternalResources` component pulls from a central list of [apps](https://github.com/cloudflare/cloudflare-docs/blob/production/src/content/apps/index.yaml) and [videos](https://github.com/cloudflare/cloudflare-docs/blob/production/src/content/videos/index.yaml).

## Import

```mdx
import { ExternalResources } from "~/components";
```

## Preview

## Props

### `type`

**required**

**type:** `"apps" | "videos"`

The type of resources to show, apps or videos.

### `tags`

**type:** `string[]`

Filter resources down to those where the `tags` property contains any of these strings.

To see a list of the available tags, and which pages are associated with them, refer to [this list](https://developers.cloudflare.com/style-guide/frontmatter/tags/).

### `products`

**type:** `string[]`

Filter resources down to those where the `products` property contains any of these strings.

### `cloudflareOnly`

**type:** `boolean`

**default:** `true`

Filter resources down to those with `cloudflare: true`.
