---
title: Error 503 · Cloudflare Support docs
description: HTTP error 503 occurs when your origin web server is overloaded.
lastUpdated: 2025-04-29T14:48:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-503/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-503/index.md
---

## Error 503: service temporarily unavailable

HTTP error 503 occurs when your origin web server is overloaded.

### Common causes

There are different causes identifiable by the error message or the location of the error:

* Error does not contain `cloudflare` or `cloudflare-nginx` in the HTML response body. In this case, the issue is likely from your origin server.
* Error contains `cloudflare` or `cloudflare-nginx` in the HTML response body. In this case, the issue may stem from Cloudflare.
* Error is only visible in logs or analytics.

### Resolution

To resolve a `503` error, first determine whether the issue originates from your origin web server or Cloudflare. The following sections provide guidance on troubleshooting both scenarios.

#### 503 Error without `cloudflare` or `cloudflare-nginx`

If the error does not contain `cloudflare` or `cloudflare-nginx` in the HTML response body, contact your hosting provider to verify if they rate limit requests to your origin web server.

#### 503 Error with `cloudflare` or `cloudflare-nginx`

If the error contains `cloudflare` or `cloudflare-nginx` in the HTML response body, a connectivity issue occurred in a Cloudflare data center. Provide [Cloudflare support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) with the following information:

* Your domain name
* The time and timezone of the `503` error occurrence
* The output of `www.example.com/cdn-cgi/trace` from the browser where the `503` error was observed (replace `www.example.com` with your actual domain and hostname)

#### 503 Error only visible in logs and analytics

These errors result from [unsuccessful prefetches from Speed Brain](https://developers.cloudflare.com/speed/optimization/content/speed-brain/#how-speed-brain-works) and can be discarded. These errors are not visible to visitors of your website. [Speed Brain](https://developers.cloudflare.com/speed/optimization/content/speed-brain/#enable-and-disable-speed-brain) can be disabled for the zone if needed (this feature cannot be disabled for a specific path).
